% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVP_methods.R
\name{fitted.shrinkTVP}
\alias{fitted.shrinkTVP}
\title{Calculate fitted historical values for an estimated TVP model}
\usage{
\method{fitted}{shrinkTVP}(object, ...)
}
\arguments{
\item{object}{A \code{shrinkTVP} object}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{shrinkTVP_fitted}
}
\description{
Calculates the fitted values for an estimated TVP model, i.e. \eqn{X_t'\beta_t}.
Note that in contrast to \code{\link{predict.shrinkTVP}} this does not include the error term.
}
\examples{
\donttest{

# Generate synthetic data
sim <- simTVP()

# Estimate a model
res <- shrinkTVP(y ~ x1 + x2, sim$data)

# Calculate fitted values
fitted <- fitted(res)

# Visualize
plot(fitted)
lines(sim$data$y, col = "forestgreen")
}
}
\seealso{
Other prediction functions: 
\code{\link{LPDS}()},
\code{\link{eval_pred_dens}()},
\code{\link{forecast_shrinkTVP}()},
\code{\link{predict.shrinkTVP}()},
\code{\link{residuals.shrinkTVP}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
