% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_using_radar.R
\name{model_radar}
\alias{model_radar}
\alias{model_using_radar}
\alias{model_using_radar_with_time_correction}
\title{Model Using Instantaneous Velocity or Radar Gun}
\usage{
model_using_radar(
  time,
  velocity,
  time_correction = 0,
  weights = 1,
  LOOCV = FALSE,
  na.rm = FALSE,
  ...
)

model_using_radar_with_time_correction(
  time,
  velocity,
  weights = 1,
  LOOCV = FALSE,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{time}{Numeric vector}

\item{velocity}{Numeric vector}

\item{time_correction}{Numeric vector. Used to filter out noisy data from the radar gun. This correction is
done by adding \code{time_correction} to \code{time}. Default is 0. See more in Samozino (2018)}

\item{weights}{Numeric vector. Default is 1}

\item{LOOCV}{Should Leave-one-out cross-validation be used to estimate model fit? Default is \code{FALSE}}

\item{na.rm}{Logical. Default is FALSE}

\item{...}{Forwarded to \code{\link[nlme]{nlme}} function}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with the following estimated parameters:
            \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[stats]{nls}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{time},
           \code{velocity}, \code{weights}, and \code{pred_velocity} columns}
        }
}
\description{
This function models the sprint instantaneous velocity using mono-exponential equation that estimates
    maximum sprinting speed (\code{MSS}) and relative acceleration (\code{TAU}). \code{velocity} is used as target or outcome
    variable, and \code{time} as predictor.
}
\examples{
instant_velocity <- data.frame(
  time = c(0, 1, 2, 3, 4, 5, 6),
  velocity = c(0.00, 4.99, 6.43, 6.84, 6.95, 6.99, 7.00)
)

sprint_model <- with(
  instant_velocity,
  model_using_radar(time, velocity)
)

# sprint_model$parameters
coef(sprint_model)
}
\references{
Samozino P. 2018. A Simple Method for Measuring Force, Velocity and Power Capabilities and Mechanical
        Effectiveness During Sprint Running. In: Morin J-B, Samozino P eds. Biomechanics of Training and Testing.
       Cham: Springer International Publishing, 237–267. DOI: 10.1007/978-3-319-05633-3_11.
}
