#
#   shopifyr: An R Interface to the Shopify API
#
#   Copyright (C) 2015 Charlie Friedemann cfriedem @ gmail.com
#   Shopify API (c) 2006-2015 Shopify Inc.
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

########### Webhook functions ########### 
#' @templateVar name Webhook
#' @templateVar urlSlug events/webhook
#' @template api
NULL

## GET /admin/api/#{api_version}/webhooks.json
## Receive a list of all Webhooks
#' @rdname Webhook
getWebhooks <- function(...) {
    private$.fetchAll("webhooks", ...)
}

## GET /admin/api/#{api_version}/webhooks/count.json
## Receive a count of all Webhooks
#' @rdname Webhook
getWebhooksCount <- function(...) {
    private$.request(private$.url("webhooks","count"), ...)$count
}

## GET /admin/api/#{api_version}/webhooks/#{id}.json
## Receive a single Webhook
#' @rdname Webhook
getWebhook <- function(webhookId, ...) {
    private$.request(private$.url("webhooks",webhookId), ...)$webhook
}

## POST /admin/api/#{api_version}/webhooks.json
## Create a new Webhook
#' @rdname Webhook
createWebhook <- function(webhook, ...) {
    webhook <- private$.wrap(webhook, "webhook", check=c("address","topic"))
    private$.request("webhooks", reqType="POST", data=webhook, ...)$webhook
}

## PUT /admin/api/#{api_version}/webhooks/#{id}.json
## Modify an existing Webhook
#' @rdname Webhook
modifyWebhook <- function(webhook, ...) {
    webhook <- private$.wrap(webhook, "webhook")
    private$.request(private$.url("webhooks",webhook$webhook$id), reqType="PUT", data=webhook, ...)$webhook
}

## DELETE /admin/api/#{api_version}/webhooks/#{id}.json
## Remove a Webhook from the database
#' @rdname Webhook
deleteWebhook <- function(webhookId, ...) {
    private$.request(private$.url("webhooks",webhookId), reqType="DELETE", ...)
}