% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radioMatrixInput.R
\name{radioMatrixInput}
\alias{radioMatrixInput}
\title{Create a matrix of radio buttons.}
\usage{
radioMatrixInput(inputId, responseItems, choices, selected = NULL, ...)
}
\arguments{
\item{inputId}{The input id}

\item{responseItems}{The questions to be asked (row labels)}

\item{choices}{Possible choices (column labels)}

\item{selected}{Initial selected value}

\item{...}{Additional arguments specific to {shinysurveys} required questions.}
}
\value{
A matrix of radio buttons that can be added to a UI definition. When
run in a Shiny application, this will return \code{NULL} until all possible
response items have been answered, at which time a data frame with the
question_id, question_type, and response, the format used in
\code{\link{getSurveyData}}.
}
\description{
Create a matrix of radio buttons.
}
\examples{
# For use as a normal Shiny input:

if (interactive()) {

  library(shiny)

  ui <- fluidPage(
    radioMatrixInput("matInput",
                     responseItems = c("Love sushi?", "Love chocolate?"),
                     choices = c("Disagree", "Neutral", "Agree"))
  )

  server <- function(input, output, session) {
    observe({
      print(input$matInput)
    })
  }

  shinyApp(ui, server)

}

# For use in {shinysurveys}

if (interactive()) {

 df <- data.frame(
   question = c(rep("I love sushi.", 3), rep("I love chocolate.",3),
   "What's your favorite food?", rep("Goat cheese is the GOAT.", 5),
   rep("Yogurt and berries are a great snack.",5),
   rep("SunButter® is a fantastic alternative to peanut butter.", 5)),
   option = c(rep(c("Disagree", "Neutral", "Agree"), 2), "text",
   rep(c("Strongly Disagree", "Disagree", "Neutral", "Agree", "Strongly Agree"), 3)),
   input_type = c(rep("matrix", 6), "text", rep("matrix", 15)),
   # For matrix questions, the IDs should be the same for each question
   # but different for each matrix input unit
   input_id = c(rep("matId", 6), "favorite_food", rep("matId2", 15)),
   dependence = NA,
   dependence_value = NA,
   required = FALSE
 )

 library(shiny)

 ui <- fluidPage(
   surveyOutput(df)
 )

 server <- function(input, output, session) {
   renderSurvey()
   observe({
     print(input$matId)
     print(input$favorite_food)
     print(input$matId2)
   })
 }

 shinyApp(ui, server)

}

}
