% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenshot.R
\name{screenshotButton}
\alias{screenshotButton}
\title{Button that captures a screenshot of a shiny app}
\usage{
screenshotButton(
  selector = "body",
  filename = "shinyscreenshot",
  id = "",
  scale = 1,
  timer = 0,
  download = TRUE,
  server_dir = NULL,
  ns = shiny::NS(NULL),
  ...
)
}
\arguments{
\item{selector}{CSS selector for the element that should be captured. If multiple
elements match the selector, only the first one is captured. Default is to capture
the entire page.}

\item{filename}{Name of the file to be saved. A PNG extension will automatically be added.}

\item{id}{As an alternative to \code{selector}, an ID of the element that should be captured
can be provided. If \code{id} is provided, then \code{selector} is ignored. When used in a module,
the \code{id} \strong{does} need to be namespaced, like any other UI element.}

\item{scale}{The scale of the image. Default is 1, which means the dimensions of the image
will be exactly the dimensions in the browser. For example, a value of 2 will result in an
image that's twice the height and width (and a larger file size).}

\item{timer}{Number of seconds to wait before taking the screenshot. Default is 0, which
takes a screenshot immediately.}

\item{download}{If \code{TRUE} (default), download the screenshot image to the user's computer.
If \code{FALSE}, the image isn't downloaded to the user, and a \code{server_dir} should be specified.}

\item{server_dir}{Directory on the server where the screenshot image should be saved. See
'Saving to the server' section below.}

\item{ns}{The \code{\link[shiny:NS]{namespace}} object of the current module if inside a Shiny module.}

\item{...}{Any other parameters that should be passed along to the \code{\link[shiny:actionButton]{shiny::actionButton()}}.}
}
\description{
Create a button that, when clicked, captures a screenshot of the Shiny app.
Screenshots can be either of the entire viewable page (default), or of a specific
section of the page. The captured image is automatically downloaded as a
PNG image.\cr\cr
This function gets called from the UI portion of a Shiny app, unlike
\code{\link[=screenshot]{screenshot()}} which is similar but gets called from the server.
}
\section{Saving to the server}{

By default, the image is downloaded to the user's computer and is not stored on the server
running the Shiny app. If a \code{server_dir} is provided, then the image is stored to this
directory on the server. Note that only the directory should be specified, not the file name.

If saving the image is successful, \code{input$shinyscreenshot} will contain the full path to
the image. If not, \code{input$shinyscreenshot} will contain an empty string (\code{""}).

The directory must exist and be writeable. If \code{NULL}, the image is not saved to the server.
If a relative path is provided, it is relative to the Shiny app's working directory. For
example, \code{server_dir="."} will save the image in the same directory that the Shiny app is in.
}

\examples{
if (interactive()) {
  library(shiny)
  library(shinyscreenshot)

  shinyApp(
    ui = fluidPage(
      h1("{shinyscreenshot} demo"),
      screenshotButton(label = "Capture entire page"),
      screenshotButton(label = "Capture plot", id = "plot"), br(), br(),
      numericInput("num", "Number of points", 50),
      plotOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderPlot({
        plot(runif(input$num))
      })
    }
  )
}
}
\seealso{
\code{\link[=screenshot]{screenshot()}}
}
