% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{metaRender}
\alias{metaRender}
\alias{metaRender2}
\title{Create a meta-reactive output}
\usage{
metaRender(
  renderFunc,
  expr,
  ...,
  env = parent.frame(),
  quoted = FALSE,
  localize = "auto",
  bindToReturn = FALSE
)

metaRender2(renderFunc, expr, ..., env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{renderFunc}{A reactive output function (e.g., \link[shiny:renderPlot]{shiny::renderPlot}, \link[shiny:renderPrint]{shiny::renderText}, \link[shiny:renderUI]{shiny::renderUI}, etc).}

\item{expr}{An expression that generates given output expected by \code{renderFunc}.}

\item{...}{Other arguments passed along to \code{renderFunc}.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{x} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{x}
will be used when \code{x} is evaluated. If \code{x} is a quosure and you
would like to use its expression as a value for \code{x}, then you must set
\code{quoted} to \code{TRUE}.}

\item{localize}{Whether or not to wrap the returned expression in \code{\link[=local]{local()}}.
The default, \code{"auto"}, only wraps expressions with a top-level \code{\link[=return]{return()}}
statement (i.e., return statements in anonymized functions are ignored).}

\item{bindToReturn}{For non-\code{localize}d expressions, should an assignment
of a meta expression be applied to the \emph{last child} of the top-level \verb{\\\{} call?}
}
\value{
An annotated render function, ready to be assigned to an output slot.
The function may also be called in meta mode (i.e., inside \code{\link[=expandChain]{expandChain()}})
to return the code in quoted form.
}
\description{
Create a meta-reactive output that, when invoked with meta-mode activated
(i.e. called within \code{\link[=expandChain]{expandChain()}} or \code{\link[=withMetaMode]{withMetaMode()}}), returns a
code expression (instead of evaluating that expression and returning the value).
}
\details{
If you wish to capture specific code inside of \code{expr} (e.g. ignore code
that has no meaning outside shiny, like \code{\link[=req]{req()}}), use \code{metaRender2()} in combination
with \code{metaExpr()}. When using \code{metaRender2()}, \code{expr} must return a \code{metaExpr()}.

Since package authors are allowed to create their own output rendering functions,
creating a meta-counterpart of an output renderer (e.g. \code{renderPlot()}) needs to be
more general than prefixing \code{meta} to the function name (as with \code{metaReactive()} and \code{metaObserve()}).
\code{metaRender()} makes some assumptions about the arguments taken by the render function,
assumptions that we believe are true for all existing render functions.
If you encounter a render function that doesn't seem to work properly,
please let us know by \href{https://github.com/rstudio/shinymeta/issues}{filing an issue on GitHub}.
}
\examples{

if (interactive()) {
  library(shiny)
  library(shinymeta)

  ui <- fluidPage(
    selectInput("var", label = "Choose a variable", choices = names(cars)),
    verbatimTextOutput("Summary"),
    verbatimTextOutput("code")
  )

  server <- function(input, output) {
    var <- metaReactive({
      cars[[..(input$var)]]
    })
    output$Summary <- metaRender(renderPrint, {
      summary(..(var()))
    })
    output$code <- renderPrint({
      expandChain(output$Summary())
    })
  }

  shinyApp(ui, server)
}

}
\seealso{
\code{\link[=metaExpr]{metaExpr()}}, \code{\link[=dotdot]{..}}
}
