% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-dropdown.R
\name{material_dropdown}
\alias{material_dropdown}
\title{Create a shinymaterial dropdown}
\usage{
material_dropdown(input_id, label, choices = NULL, selected = NULL,
  multiple = NULL, color = NULL)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The dropdown label.}

\item{choices}{Named vector. The option names and underyling values.}

\item{selected}{String. The initially selected underyling value.}

\item{multiple}{Boolean. Can multiple items be selected?}

\item{color}{String. The color of the dropdown choices. Leave empty for the default color. Visit \url{http://materializecss.com/color.html} for a list of available colors. \emph{This input requires using color hex codes, rather than the word form. E.g., "#ef5350", rather than "red lighten-1".}}
}
\description{
Build a shinymaterial dropdown.
}
\examples{
material_dropdown(
  input_id = "example_dropdown",
  label = "Drop down",
  choices = c(
    "Chicken" = "c",
    "Steak" = "s",
    "Fish" = "f"
  ),
  selected = c("c"),
  multiple = FALSE,
  color = "#ef5350"
)
}
