% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{slServer}
\alias{slServer}
\title{Start a ShinyLight server}
\usage{
slServer(
  interface,
  appDir = NULL,
  host = "127.0.0.1",
  port = NULL,
  daemonize = FALSE,
  initialize = NULL
)
}
\arguments{
\item{interface}{List of functions you want to be able to call from
the browser. If you want to use the Shinylight Framework, this should
have one member \code{getSchema}. For details of this, see the
documentation for [shinylightFrameworkStart].}

\item{appDir}{Directory containing files to serve (for example
system.file("www", package = "your-package"))}

\item{host}{IP address to listen on, default is \code{"127.0.0.1"}
(localhost). Use \code{"0.0.0.0"} to run in a docker container.}

\item{port}{Internet port of the virtual server. If not defined, a
random free port will be chosen and the browser will be opened
to show the GUI.}

\item{daemonize}{If TRUE, keep serving forever without returning.
This is useful when called from \code{RScript}, to keep}

\item{initialize}{A json string or list (that will be converted to a
JSON string) to be passed to the JavaScript as initial data. For
non-framework apps, the index.html must contain a line containing
\code{var shinylight_initial_data=}, which will be replaced with
code that sets \code{shinylight_initial_data} to this supplied JSON
string.}
}
\value{
server object, unless daemonize is TRUE in which case the
function will not return.
}
\description{
Start a ShinyLight server
}
\examples{
# You can leave out port and daemonize to launch a browser
# pointing at your server
server <- slServer(
  port = 50052,
  interface = list(
    multiply = function(x, y) { x * y }
  )
)
# Normally we would use shinylight.js to send the function over
# and receive the result, not R and websocket.
ws <- websocket::WebSocket$new("ws://127.0.0.1:50052/x")
resultdata <- NULL
ws$onMessage(function(event) {
  resultdata <<- jsonlite::fromJSON(event$data)$result$data
})
ws$onOpen(function(event) {
  ws$send('{ "method": "multiply", "params": { "x": 3, "y": 47 } }')
})
timeout = 30
while(is.null(resultdata) && 0 < timeout) {
  later::run_now()
  Sys.sleep(0.1)
  timeout <- timeout - 1
}
ws$close()
slStop(server)
stopifnot(resultdata == 141)  # multiply(3, 47) == 141
grDevices::png()  # workaround; you do not have to do this
}
\seealso{
\code{\link{slStop}} to stop a running server, and
\code{\link{slRunRServer}} to run a server that just accepts R code.
}
