% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{getAddress}
\alias{getAddress}
\title{Obtains the address that the server is listening on}
\usage{
getAddress(server)
}
\arguments{
\item{server}{The server (returned by \code{\link{slServer}}
or \code{\link{slRunRServer}})}
}
\value{
The HTTP address as \code{protocol://address:port}
}
\description{
Obtains the address that the server is listening on
}
\examples{
server <- slServer(
  port = 50051,
  interface = list(
    multiply = function(x, y) { x * y }
  )
)
address <- getAddress(server)
# ...
slStop(server)
stopifnot(address == "http://127.0.0.1:50051")
}
