% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/jsFunc-text.R
\name{text}
\alias{text}
\title{Change the text inside an element}
\usage{
text(...)
}
\arguments{
\item{...}{The following parameters are available:
\tabular{ll}{
  \strong{\code{id}}    \tab The id of the element/Shiny tag \cr
  \strong{\code{text}}  \tab The text to place inside the element.
                                  Can be either simple quoted text,
                                  R expressions, or valid HTML code.\cr
  \strong{\code{add}}   \tab If \code{TRUE}, then append \code{text} to the
                             contents of the element; otherwise overwrite it.
                             (default: \code{FALSE}) \cr
}}
}
\description{
Change the text or HTML inside an element.  The given text can be any
R expression, and it can either be appended to the contents of the element
or overwrite it (default).  This function can also be used to add HTML
tags inside another element by passing in valid HTML instead of plain text.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::actionButton("btn", "Click me"),
      shiny::p(id = "element", "Watch what happens to me")
    ),
    server = function(input, output) {
      shiny::observeEvent(input$btn, {
        # Change the following line for more examples
        text("element", paste0("The date is ", date()))
      })
    }
  )
}
\dontrun{
  # The shinyjs function call in the above app can be replaced by
  # any of the following examples to produce similar Shiny apps
  text("element", "Hello!")
  text("element", " Hello!", TRUE)
  text("element", "<strong>bold</strong> that was achieved with HTML")
  local({val <- "some text"; text("element", val)})
  text(id = "element", add = TRUE, text = input$btn)
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}}
}

