% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mouse_interactions.R
\name{Interactions}
\alias{Interactions}
\alias{jqui_resizabled}
\alias{jqui_sortabled}
\alias{jqui_draggabled}
\alias{jqui_droppabled}
\alias{jqui_selectabled}
\alias{jqui_sortable}
\alias{jqui_draggable}
\alias{jqui_droppable}
\alias{jqui_selectable}
\alias{jqui_resizable}
\title{Mouse interactions}
\usage{
jqui_resizabled(tag, options = NULL)

jqui_sortabled(tag, options = NULL)

jqui_draggabled(tag, options = NULL)

jqui_droppabled(tag, options = NULL)

jqui_selectabled(tag, options = NULL)

jqui_sortable(selector, switch = TRUE, options = NULL)

jqui_draggable(selector, switch = TRUE, options = NULL)

jqui_droppable(selector, switch = TRUE, options = NULL)

jqui_selectable(selector, switch = TRUE, options = NULL)

jqui_resizable(selector, switch = TRUE, options = NULL)
}
\arguments{
\item{tag}{A shiny tag object to add interactions to.}

\item{options}{A list of interaction options. Ignored when \code{switch} is set as
\code{FALSE}. In addition to the
\href{http://api.jqueryui.com/category/interactions/}{interaction_specific_options},
this parameter also accept a shiny option that controls the shiny input
value returned from the element. See Details.}

\item{selector}{A
\href{https://api.jquery.com/category/selectors/}{jQuery_selector} that
determines the shiny tag element(s) whose interaction is to be enabled or
disabled.}

\item{switch}{A boolean value to determine whether to enable or disable an
interaction.}
}
\value{
\code{jqui_draggabled}, \code{jqui_droppabled}, \code{jqui_resizabled},
\code{jqui_selectabled} and \code{jqui_sortabled} returns a modified shiny tag object
with interaction enabled.
}
\description{
These functions initialize or switch on/off jQuery UI mouse interactions
(\href{http://api.jqueryui.com/draggable/}{draggable},
\href{http://api.jqueryui.com/droppable/}{droppable},
\href{http://api.jqueryui.com/resizable/}{resizable},
\href{http://api.jqueryui.com/selectable/}{selectable},
\href{http://api.jqueryui.com/sortable/}{sortable}) to shiny tag element(s).
}
\details{
The function \code{jqui_draggabled}, \code{jqui_droppabled}, \code{jqui_resizabled},
\code{jqui_selectabled} and \code{jqui_sortabled} initialize the element's interactions
and should be used in \code{ui} of a shiny app. The function \code{jqui_draggable},
\code{jqui_droppable}, \code{jqui_resizable}, \code{jqui_selectable} and \code{jqui_sortable}
switch on/off interactions and should be used in \code{server} of a shiny app.

If an element has an \code{id} and its interaction is initialized or switched on,
users can get access to some internally defined shiny input values. Users can
override the default shiny input settings by passing a \code{shiny} option to the
\code{options} parameter. Please see the vignette \code{Introduction to shinyjqui} for
more details.
}
\examples{
library(shiny)
library(highcharter)

## used in ui
jqui_resizabled(actionButton('btn', 'Button'))
jqui_draggabled(plotOutput('plot', width = '400px', height = '400px'),
                options = list(axis = 'x'))
jqui_selectabled(
  div(
    id = 'sel_plots',
    highchartOutput('highchart', width = '300px'),
    plotOutput('ggplot', width = '300px')
  ),
  options = list(
    classes = list(`ui-selected` = 'ui-state-highlight')
  )
)
jqui_sortabled(tags$ul(
  id = 'lst',
  tags$li('A'),
  tags$li('B'),
  tags$li('C')
))

## used in server
\dontrun{
  jqui_draggable('#foo', options = list(grid = c(80, 80)))
  jqui_droppable('.foo', switch = FALSE)
}

## use shiny input
if (interactive()) {
  server <- function(input, output) {
    output$foo <- renderHighchart({
      hchart(mtcars, "scatter", hcaes(x = cyl, y = mpg))
    })
    output$position <- renderPrint({
      print(input$foo_position)
    })
  }
  ui <- fluidPage(
    verbatimTextOutput('position'),
    jqui_draggabled(highchartOutput('foo', width = '200px', height = '200px'))
  )
  shinyApp(ui, server)
}

## custom shiny input
func <- JS('function(event, ui){return $(event.target).offset();}')
options <-  list(
  shiny = list(
    abs_position = list(
      dragcreate = func, # send returned value back to shiny when interaction is created.
      drag = func # send returned value to shiny when dragging.
    )
  )
)
jqui_draggabled(highchartOutput('foo', width = '200px', height = '200px'),
                options = options)


}
