% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{screenOutput}
\alias{screenOutput}
\title{Create a screen output element}
\usage{
screenOutput(outputId, next_label = NULL, prev_label = NULL,
  next_condition = NULL, prev_condition = NULL, class = NULL, ...)
}
\arguments{
\item{outputId}{output variable to read the value from}

\item{next_label}{specific label of the "next" control for this screen. If \code{NULL},
use the default one for the current glide.}

\item{prev_label}{specific label of the "back" control for this screen. If \code{NULL},
use the default one for the current glide.}

\item{next_condition}{condition for the "next" control to be enabled. Same syntax
as \code{shiny::conditionalPanel}.}

\item{prev_condition}{condition for the "back" control to be enabled. Same syntax
as \code{shiny::conditionalPanel}.}

\item{class}{screen CSS classes. \code{glide__slide} is automatically added.}

\item{...}{other arguments to pass to the container tag function.}
}
\description{
Insert a screen output element in a shiny app UI. This must be used with a
\code{renderUI} reactive expression in the app server.
}
\details{
\strong{Important :} for this to work, you have to add a
\code{outputOptions(output, id, suspendWhenHidden = FALSE)} in your app
server. See example.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fixedPage(
 h3("Simple shinyglide app"),
 glide(
    screen(
      p("First screen."),
    ),
    screenOutput("screen"),
    screen(
      p("Final screen."),
    )
  )
)

server <- function(input, output, session) {

  output$screen <- renderUI({
    p("Second screen.")
  })
  outputOptions(output, "screen", suspendWhenHidden = FALSE)

}

shinyApp(ui, server)

}


}
