% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{userPost}
\alias{userPost}
\title{AdminLTE2 user post}
\usage{
userPost(..., id = NULL, src = NULL, author = NULL,
  description = NULL, collapsible = TRUE, collapsed = FALSE)
}
\arguments{
\item{...}{post content, slot for userPostToolItemList.}

\item{id}{unique id of the post.}

\item{src}{profile image, if any.}

\item{author}{post author.}

\item{description}{post description.}

\item{collapsible}{If TRUE, display a button in the upper right that allows the user to collapse the comment.}

\item{collapsed}{Whether the comment is collapsed when the application starts, FALSE by default.}
}
\description{
Create a user post
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Box with user comment",
      status = "primary",
      userPost(
       id = 1,
       src = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
       author = "Jonathan Burke Jr.",
       description = "Shared publicly - 7:30 PM today",
       "Lorem ipsum represents a long-held tradition for designers, 
       typographers and the like. Some people hate it and argue for 
       its demise, but others ignore the hate as they create awesome 
       tools to help create filler text for everyone from bacon 
       lovers to Charlie Sheen fans.",
       userPostToolItemList(
        userPostToolItem(dashboardLabel("item 1")),
        userPostToolItem(dashboardLabel("item 2", status = "danger"), side = "right")
       )
      ),
      userPost(
       id = 2,
       src = "https://adminlte.io/themes/AdminLTE/dist/img/user6-128x128.jpg",
       author = "Adam Jones",
       description = "Shared publicly - 5 days ago",
       userPostMedia(src = "https://adminlte.io/themes/AdminLTE/dist/img/photo2.png"),
       userPostToolItemList(
        userPostToolItem(dashboardLabel("item 1")),
        userPostToolItem(dashboardLabel("item 2", status = "danger"), side = "right")
       )
      )
     )
    ),
    title = "userPost"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
