% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-icon.R
\name{numericInputIcon}
\alias{numericInputIcon}
\title{Create a numeric input control with icon(s)}
\usage{
numericInputIcon(
  inputId,
  label,
  value,
  min = NULL,
  max = NULL,
  step = NULL,
  icon = NULL,
  size = NULL,
  help_text = NULL,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}

\item{icon}{An \code{icon} or a \code{list}, containing \code{icon}s
or text, to be displayed on the right or left of the numeric input.}

\item{size}{Size of the input, default to \code{NULL}, can
be \code{"sm"} (small) or \code{"lg"} (large).}

\item{help_text}{Help text placed below the widget and only
displayed if value entered by user is outside of \code{min} and \code{max}.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}
}
\value{
A numeric input control that can be added to a UI definition.
}
\description{
Extend form controls by adding text or icons before,
 after, or on both sides of a classic \code{numericInput}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    tags$h2("numericInputIcon examples"),
    fluidRow(
      column(
        width = 6,
        numericInputIcon(
          inputId = "ex1",
          label = "With an icon",
          value = 10,
          icon = icon("percent")
        ),
        verbatimTextOutput("res1"),
        numericInputIcon(
          inputId = "ex2",
          label = "With an icon (right)",
          value = 90,
          step = 10,
          icon = list(NULL, icon("percent"))
        ),
        verbatimTextOutput("res2"),
        numericInputIcon(
          inputId = "ex3",
          label = "With text",
          value = 50,
          icon = list("km/h")
        ),
        verbatimTextOutput("res3"),
        numericInputIcon(
          inputId = "ex4",
          label = "Both side",
          value = 10000,
          icon = list(icon("dollar"), ".00")
        ),
        verbatimTextOutput("res4"),
        numericInputIcon(
          inputId = "ex5",
          label = "Sizing",
          value = 10000,
          icon = list(icon("dollar"), ".00"),
          size = "lg"
        ),
        verbatimTextOutput("res5")
      )
    )
  )

  server <- function(input, output, session) {

    output$res1 <- renderPrint(input$ex1)
    output$res2 <- renderPrint(input$ex2)
    output$res3 <- renderPrint(input$ex3)
    output$res4 <- renderPrint(input$ex4)
    output$res5 <- renderPrint(input$ex5)

  }

  shinyApp(ui, server)
}
}
