% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{inputSweetAlert}
\alias{inputSweetAlert}
\title{Launch an input text dialog}
\usage{
inputSweetAlert(session, inputId, title = NULL, text = NULL,
  type = NULL, btn_labels = "Ok", placeholder = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{title}{Title of the alert.}

\item{text}{Text of the alert.}

\item{type}{Type of the alert : info, success, warning or error.}

\item{btn_labels}{Labels for button(s).}

\item{placeholder}{A character string giving the user a hint as to
what can be entered into the control.}
}
\description{
Launch a popup with a text input
}
\examples{
\dontrun{

if (interactive()) {

library("shiny")
library("shinyWidgets")


ui <- fluidPage(
  tags$h1("Confirm sweet alert"),
  actionButton(inputId = "go", label = "Launch input text dialog"),
  verbatimTextOutput(outputId = "res")
)
server <- function(input, output, session) {

  observeEvent(input$go, {
    inputSweetAlert(
      session = session, inputId = "mytext",
      title = "What's your name ?"
    )
  })

  output$res <- renderPrint(input$mytext)

}

shinyApp(ui = ui, server = server)

}

}
}
\seealso{
\code{\link{sendSweetAlert}}, \code{\link{confirmSweetAlert}}
}
