% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{sendSweetAlert}
\alias{sendSweetAlert}
\title{Display a Sweet Alert to the user}
\usage{
sendSweetAlert(session, title = "Title", text = NULL, type = NULL,
  btn_labels = "Ok")
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{title}{Title of the alert.}

\item{text}{Text of the alert.}

\item{type}{Type of the alert : info, success, warning or error.}

\item{btn_labels}{Label(s) for button(s), can be of length 2,
in which case the alert will have two buttons.}
}
\description{
Send a message from the server and launch a sweet alert in the UI.
}
\examples{
\dontrun{
if (interactive()) {

shinyApp(
  ui = fluidPage(
    tags$h1("Click the button"),
    actionButton(
      inputId = "success",
      label = "Launch a success sweet alert"
    ),
    actionButton(
      inputId = "error",
      label = "Launch an error sweet alert"
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$success, {
      sendSweetAlert(
        session = session,
        title = "Success !!",
        text = "All in order",
        type = "success"
      )
    })
    observeEvent(input$error, {
      sendSweetAlert(
        session = session,
        title = "Error !!",
        text = "It's broken...",
        type = "error"
      )
    })
  }
)

}
}

}
\seealso{
\code{\link{confirmSweetAlert}}, \code{\link{inputSweetAlert}}
}
