% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw-dropdown.R
\name{dropdown}
\alias{dropdown}
\title{Dropdown}
\usage{
dropdown(..., style = "default", status = "default", size = "md",
  icon = NULL, label = NULL, tooltip = FALSE, right = FALSE,
  up = FALSE, width = NULL, animate = FALSE)
}
\arguments{
\item{...}{List of tag to be displayed into the dropdown menu.}

\item{style}{Character. if \code{default} use Bootstrap button (like an \code{actionButton}), else use an
\code{actionBttn}, see argument \code{style} for possible values.}

\item{status}{Color, must be a valid Bootstrap status : default, primary, info, success, warning, danger.}

\item{size}{Size of the button : default, lg, sm, xs.}

\item{icon}{An icon to appear on the button.}

\item{label}{Label to appear on the button. If circle = TRUE and tooltip = TRUE, label is used in tooltip.}

\item{tooltip}{Put a tooltip on the button, you can customize tooltip with \code{tooltipOptions}.}

\item{right}{Logical. The dropdown menu starts on the right.}

\item{up}{Logical. Display the dropdown menu above.}

\item{width}{Width of the dropdown menu content.}

\item{animate}{Add animation on the dropdown, can be logical or result of \code{animateOptions}.}
}
\description{
Create a dropdown menu
}
\details{
This function is similar to \code{dropdownButton} but don't use Boostrap, so you can put \code{pickerInput} in it.
Moreover you can add animations on the appearance / disappearance of the dropdown with animate.css.
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

dropdown(
 "Your contents goes here ! You can pass several elements",
 circle = TRUE, status = "danger", icon = icon("gear"), width = "300px",
 tooltip = tooltipOptions(title = "Click to see inputs !")
)

}
}
}
\seealso{
\code{\link{animateOptions}} for animation, \code{\link{tooltipOptions}} for tooltip and
\code{\link{actionBttn}} for the button.
}
