% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{receiveSweetAlert}
\alias{receiveSweetAlert}
\alias{sendSweetAlert}
\title{Display a Sweet Alert}
\usage{
receiveSweetAlert(messageId)

sendSweetAlert(messageId, title = "Title", text = "Text", type = NULL,
  html = FALSE)
}
\arguments{
\item{messageId}{The sweet alert id.}

\item{title}{Title of the alert}

\item{text}{Text of the alert}

\item{type}{Type of the alert : null, info, success, warning or error}

\item{html}{Logical. Use HTML in the text}
}
\description{
Send a message from the server and launch a sweet alert in the UI.
}
\note{
Use \code{receiveSweetAlert()} in the UI and \code{sendSweetAlert()} in the server.
}
\examples{
\dontrun{
if (interactive()) {
 shinyApp(
  ui = fluidPage(
    tags$h1("Click the button"),
    actionButton(inputId = "success", label = "Launch a success sweet alert"),
    receiveSweetAlert(messageId = "successSw")
  ),
  server = function(input, output) {
    observeEvent(input$success, {
      sendSweetAlert(
        messageId = "successSw", title = "Success !!", text = "All in order", type = "success"
      )
    })
  }
 )
}
}

}
