% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_edges_to_adjacency.R
\name{get_adjacency.default}
\alias{get_adjacency.default}
\title{get_adjacency.default}
\usage{
\method{get_adjacency}{default}(edges, type = c("unipartite", "bipartite"), directed = FALSE)
}
\arguments{
\item{edges}{Can be a table which is a list pair of nodes (nodes ids are one the two first columns) a numerical third column can be associated will be the connections values.}

\item{type}{network type can be `'bipartite'` or `'unipartite'`}

\item{directed}{whether or not connections are directed (`TRUE`) or symmetrical (`FALSE`) (default is set to `TRUE`)}
}
\value{
an adjacency/incidence matrix (data.frame) representing the network
}
\description{
A fct that build an adjacency matrix from a list of edges
}
\examples{
# For unipartite network
data_uni <- FungusTreeNetwork$networks$tree_tree

# If the network is symmetric:
my_mat <- get_adjacency(data_uni$edges,
  type = data_uni$type,
  directed = FALSE
)
# If the network is directed:
my_mat <- get_adjacency(data_uni$edges,
  type = data_uni$type,
  directed = TRUE
)

# For bipartite network
data_bi <- FungusTreeNetwork$networks$fungus_tree

my_mat <- get_adjacency(data_bi$edges, type = data_bi$type)

# In any case with a 2 columns data.frames the network is considered binary and each line is a 1.
binary_net <- FungusTreeNetwork$fungus_tree$edges[, -3]

my_mat <- get_adjacency(binary_net, type = data_bi$type)

}
