% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softeners.R
\name{error_on_softened}
\alias{error_on_softened}
\title{Throw an error if any safety checks have been disabled}
\usage{
error_on_softened()
}
\value{
Invisible TRUE if no safety checks are disabled; otherwise, an error is thrown.
}
\description{
This function checks if any safety checks have been disabled via options
intended for local development use only. If any such options are detected,
an error is thrown to prevent accidental use in production environments.
}
\details{
It checks for the following options:
\itemize{
\item \code{shinyOAuth.skip_browser_token}: Skips browser cookie presence check
\item \code{shinyOAuth.skip_id_sig}: Skips ID token signature verification
\item \code{shinyOAuth.print_errors}: Enables printing of error messages
\item \code{shinyOAuth.print_traceback}: Enables printing of tracebacks (opt-in only; default FALSE)
\item \code{shinyOAuth.expose_error_body}: Exposes HTTP response bodies
}

Note: Tracebacks are only treated as a "softened" behavior when the
\code{shinyOAuth.print_traceback} option is explicitly set to \code{TRUE}.
The default is \code{FALSE}, even in interactive or test sessions.
}
\examples{
# Throw an error if any developer-only softening options are enabled
# Below call does not error if run with default options:
error_on_softened()

# Below call would error (is therefore not run):
\dontrun{
options(shinyOAuth.skip_id_sig = TRUE)
error_on_softened()
}
}
