% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Radio}
\alias{f7Radio}
\alias{updateF7Radio}
\alias{f7RadioChoice}
\title{Framework7 radio input}
\usage{
f7Radio(
  inputId,
  label,
  choices = NULL,
  selected = NULL,
  position = c("left", "right"),
  style = list(inset = FALSE, outline = FALSE, dividers = FALSE, strong = FALSE)
)

updateF7Radio(
  inputId,
  label = NULL,
  choices = NULL,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)

f7RadioChoice(..., title, subtitle = NULL, after = NULL)
}
\arguments{
\item{inputId}{Input id.}

\item{label}{Input label}

\item{choices}{List of choices. Can be a simple
vector or named list or a list of \link{f7RadioChoice} or
\link{f7CheckboxChoice}}

\item{selected}{Selected element. NULL by default. If you pass
\link{f7RadioChoice} or \link{f7CheckboxChoice} in choices,
selected must be a numeric value corresponding to the index of the element to select.}

\item{position}{Check mark side.
\code{"left"} or \code{"right"}.}

\item{style}{Input style. Inherit from \link{f7List} options
such as outline, inset, strong and dividers.}

\item{session}{Shiny session object.}

\item{...}{Choice content. Text is striped if too long.}

\item{title}{Item title.}

\item{subtitle}{Item subtitle.}

\item{after}{Display at the right of title.}
}
\description{
\code{f7Radio} creates a radio button input.

\code{updateF7Radio} updates a radio button input.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Update radio",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update f7Radio"),
      f7Block(f7Button("update", "Update radio")),
      f7Block(
        f7Radio(
          inputId = "radio",
          label = "Choose a fruit:",
          choices = c("banana", "apple", "peach"),
          selected = "apple",
          position = "right"
        ),
        textOutput("res")
      ),
      f7Block(
        f7Radio(
          inputId = "radio2",
          label = "Custom choices",
          choices = list(
            f7RadioChoice(
              "Lorem ipsum dolor sit amet, consectetur adipiscing elit.
            Nulla sagittis tellus ut turpis condimentum,
            ut dignissim lacus tincidunt",
              title = "Choice 1",
              subtitle = "David",
              after = "March 16, 2024"
            ),
            f7RadioChoice(
              "Cras dolor metus, ultrices condimentum sodales sit
            amet, pharetra sodales eros. Phasellus vel felis tellus.
            Mauris rutrum ligula nec dapibus feugiat",
              title = "Choice 2",
              subtitle = "Veerle",
              after = "March 17, 2024"
            )
          ),
          selected = 2,
          style = list(
            outline = TRUE,
            strong = TRUE,
            inset = TRUE,
            dividers = TRUE
          )
        ),
        textOutput("res2")
      )
    )
  ),
  server = function(input, output, session) {
    output$res <- renderText(input$radio)
    output$res2 <- renderText(input$radio2)

    observeEvent(input$update, {
      updateF7Radio(
        session,
        inputId = "radio",
        label = "New label",
        choices = colnames(mtcars),
        selected = colnames(mtcars)[1]
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
