% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Radio}
\alias{f7Radio}
\alias{updateF7Radio}
\title{Framework7 radio input}
\usage{
f7Radio(inputId, label, choices = NULL, selected = NULL)

updateF7Radio(
  inputId,
  label = NULL,
  choices = NULL,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Radio input id.}

\item{label}{New radio label}

\item{choices}{New list of choices.}

\item{selected}{New selected element. NULL by default.}

\item{session}{Shiny session object.}
}
\description{
\code{f7Radio} creates a radio button input.

\code{updateF7Radio} updates a radio button input.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Radio"),
     f7Radio(
      inputId = "radio",
      label = "Choose a fruit:",
      choices = c("banana", "apple", "peach"),
      selected = "apple"
     ),
     plotOutput("plot")
    )
   ),
   server = function(input, output) {
    output$plot <- renderPlot({
     if (input$radio == "apple") hist(mtcars[, "mpg"])
    })
   }
 )
}
# Update radio
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Update radio",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update f7Radio"),
      f7Button("go", "Update radio"),
      f7Radio(
        inputId = "radio",
        label = "Choose a fruit:",
        choices = c("banana", "apple", "peach"),
        selected = "apple"
      ),
      textOutput("radio_value")
    )
  ),
  server = function(input, output, session) {
    output$radio_value <- renderText(input$radio)

    observeEvent(input$go, {
      updateF7Radio(
        session,
        inputId = "radio",
        label = "New label",
        choices = colnames(mtcars),
        selected = colnames(mtcars)[1]
      )
    })
  }
 )
}
}
