% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Panel.R
\name{f7Panel}
\alias{f7Panel}
\alias{updateF7Panel}
\title{Framework7 panel}
\usage{
f7Panel(
  ...,
  id = NULL,
  title = NULL,
  side = c("left", "right"),
  theme = c("dark", "light"),
  effect = c("reveal", "cover"),
  resizable = FALSE
)

updateF7Panel(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Panel content. Slot for \link{f7PanelMenu}, if used as a sidebar.}

\item{id}{Panel unique id.}

\item{title}{Panel title.}

\item{side}{Panel side: "left" or "right".}

\item{theme}{Panel background color: "dark" or "light".}

\item{effect}{Whether the panel should behave when opened: "cover" or "reveal".}

\item{resizable}{Whether to enable panel resize. FALSE by default.}

\item{session}{Shiny session object.}
}
\description{
\code{f7Panel} is a sidebar element. It may be used as a simple
sidebar or as a container for \link{f7PanelMenu} in case of
\link{f7SplitLayout}.

\code{updateF7Panel} toggles an \link{f7Panel} from the server.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Panels",
     f7SingleLayout(
       navbar = f7Navbar(
         title = "Single Layout",
         hairline = FALSE,
         shadow = TRUE,
         leftPanel = TRUE,
         rightPanel = TRUE
       ),
       panels = tagList(
         f7Panel(side = "left", id = "mypanel1"),
         f7Panel(side = "right", id = "mypanel2")
       ),
       toolbar = f7Toolbar(
         position = "bottom",
         icons = TRUE,
         hairline = FALSE,
         shadow = FALSE,
         f7Link(label = "Link 1", href = "https://www.google.com"),
         f7Link(label = "Link 2", href = "https://www.google.com")
       ),
       # main content
       f7Shadow(
         intensity = 10,
         hover = TRUE,
         f7Card(
           title = "Card header",
           sliderInput("obs", "Number of observations", 0, 1000, 500),
           h1("You only see me by opening the left panel"),
           plotOutput("distPlot"),
           footer = tagList(
             f7Button(color = "blue", label = "My button", href = "https://www.google.com"),
             f7Badge("Badge", color = "green")
           )
         )
       )
     )
   ),
   server = function(input, output, session) {

     observeEvent(input$mypanel2, {

       state <- if (input$mypanel2) "open" else "closed"

       f7Toast(
         text = paste0("Right panel is ", state),
         position = "center",
         closeTimeout = 1000,
         closeButton = FALSE
       )
     })

     output$distPlot <- renderPlot({
       if (input$mypanel1) {
         dist <- rnorm(input$obs)
         hist(dist)
       }
     })
   }
 )
}
# Toggle panel
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Update panel menu",
     f7SingleLayout(
       navbar = f7Navbar(
         title = "Single Layout",
         hairline = FALSE,
         shadow = TRUE,
         leftPanel = TRUE,
         rightPanel = TRUE
       ),
       panels = tagList(
         f7Panel(side = "left", id = "mypanel1", theme = "light", effect = "cover"),
         f7Panel(side = "right", id = "mypanel2", theme = "light")
       ),
       toolbar = f7Toolbar(
         position = "bottom",
         icons = TRUE,
         hairline = FALSE,
         shadow = FALSE,
         f7Link(label = "Link 1", href = "https://www.google.com"),
         f7Link(label = "Link 2", href = "https://www.google.com")
       )
     )
   ),
   server = function(input, output, session) {

     observe({
       print(
         list(
           panel1 = input$mypanel1,
           panel2 = input$mypanel2
         )
       )
     })

     observe({
       invalidateLater(2000)
       updateF7Panel(id = "mypanel1")
     })

   }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
