% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Toggle}
\alias{updateF7Toggle}
\title{Change the value of a toggle input on the client}
\usage{
updateF7Toggle(session, inputId, checked = NULL, color = NULL)
}
\arguments{
\item{session}{The session object passed to function given to the server.}

\item{inputId}{The id of the input object.}

\item{checked}{Whether the toggle is TRUE or FALSE.}

\item{color}{Toggle color.}
}
\description{
Change the value of a toggle input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "updateF7Toggle"),
       f7Card(
         f7Button(inputId = "update", label = "Update toggle"),
         f7Toggle(
           inputId = "toggle",
           label = "My toggle",
           color = "pink",
           checked = FALSE
         ),
         verbatimTextOutput("test")
       )
     )
   ),
   server = function(input, output, session) {

     output$test <- renderPrint({input$toggle})

     observeEvent(input$update, {
       updateF7Toggle(
         session,
         inputId = "toggle",
         checked = TRUE,
         color = "green"
       )
     })
   }
 )
}
}
