% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dirchoose.R, R/filechoose.R, R/filesave.R
\name{parseDirPath}
\alias{parseDirPath}
\alias{parseFilePaths}
\alias{parseSavePath}
\alias{shinyFiles-parsers}
\title{Convert the output of a selection to platform specific path(s)}
\usage{
parseDirPath(roots, selection)

parseFilePaths(roots, selection)

parseSavePath(roots, selection)
}
\arguments{
\item{roots}{The path to the root as specified in the \code{shinyFileChoose()}
call in \code{shinyServer()}}

\item{selection}{The corresponding input variable to be parsed}
}
\value{
A data frame mathcing the format of \code{\link[shiny]{fileInput}}
}
\description{
This function takes the value of a shinyFiles button input variable and
converts it to be easier to work with on the server side. In the case of file
selections  and saving the input variable is converted to a data frame (using
\code{parseFilePaths()} or \code{parseSavePath() respectively}) of the same
format as that provided by \code{\link[shiny]{fileInput}}. The only caveat
here is that the MIME type cannot be inferred in file selections so this will
always be an empty string and new files doesn't have a size so this is left
out with file saving. In the case of folder selection the input variable is
converted to a string (using \code{parseDirPath()}) giving the absolute path
to the selected folder.
}
\details{
The use of \code{parseFilePaths} makes it easy to substitute fileInput and
shinyFiles in your code as code that relies on the values of a file selection
doesn't have to change.
}
\examples{
\dontrun{
ui <- shinyUI(bootstrapPage(
    shinyFilesButton('files', 'File select', 'Please select a file', FALSE),
    verbatimTextOutput('rawInputValue'),
    verbatimTextOutput('filepaths')
))
server <- shinyServer(function(input, output, session) {
    roots = c(wd='.')
    shinyFileChoose(input, 'files', session=session, roots=roots,
                                    filetypes=c('', '.txt'))
    output$rawInputValue <- renderPrint({str(input$files)})
    output$filepaths <- renderPrint({parseFilePaths(roots, input$files)})
})

runApp(list(
    ui=ui,
    server=server
))
}
}
\seealso{
Other shinyFiles: \code{\link{shinyDirButton}},
  \code{\link{shinyFiles-buttons}},
  \code{\link{shinyFilesButton}},
  \code{\link{shinySaveButton}};
  \code{\link{shinyDirChoose}},
  \code{\link{shinyFileChoose}},
  \code{\link{shinyFileSave}},
  \code{\link{shinyFiles-observers}};
  \code{\link{shinyFilesExample}}
}

