% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-layout.R
\name{fillRow}
\alias{fillRow}
\alias{fillCol}
\title{Flex Box-based row/column layouts}
\usage{
fillRow(..., flex = 1, width = "100\%", height = "100\%")

fillCol(..., flex = 1, width = "100\%", height = "100\%")
}
\arguments{
\item{...}{UI objects to put in each row/column cell; each argument will
occupy a single cell. (To put multiple items in a single cell, you can use
\code{\link{tagList}} or \code{\link{div}} to combine them.) Named
arguments will be used as attributes on the \code{div} element that
encapsulates the row/column.}

\item{flex}{Determines how space should be distributed to the cells. Can be a
single value like \code{1} or \code{2} to evenly distribute the available
space; or use a vector of numbers to specify the proportions. For example,
\code{flex = c(2, 3)} would cause the space to be split 40\%/60\% between
two cells. NA values will cause the corresponding cell to be sized
according to its contents (without growing or shrinking).}

\item{width, height}{The total amount of width and height to use for the
entire row/column. For the default height of \code{"100\%"} to be
effective, the parent must be \code{fillPage}, another
\code{fillRow}/\code{fillCol}, or some other HTML element whose height is
not determined by the height of its contents.}
}
\description{
Creates row and column layouts with proportionally-sized cells, using the
Flex Box layout model of CSS3. These can be nested to create arbitrary
proportional-grid layouts. \strong{Warning:} Flex Box is not well supported
by Internet Explorer, so these functions should only be used where modern
browsers can be assumed.
}
\details{
If you try to use \code{fillRow} and \code{fillCol} inside of other
  Shiny containers, such as \code{\link{sidebarLayout}},
  \code{\link{navbarPage}}, or even \code{tags$div}, you will probably find
  that they will not appear. This is due to \code{fillRow} and \code{fillCol}
  defaulting to \code{height="100\%"}, which will only work inside of
  containers that have determined their own size (rather than shrinking to
  the size of their contents, as is usually the case in HTML).

  To avoid this problem, you have two options:
  \itemize{
    \item only use \code{fillRow}/\code{fillCol} inside of \code{fillPage},
      \code{fillRow}, or \code{fillCol}
    \item provide an explicit \code{height} argument to
      \code{fillRow}/\code{fillCol}
  }
}
\examples{
# Only run this example in interactive R sessions.
if (interactive()) {

ui <- fillPage(fillRow(
  plotOutput("plotLeft", height = "100\%"),
  fillCol(
    plotOutput("plotTopRight", height = "100\%"),
    plotOutput("plotBottomRight", height = "100\%")
  )
))

server <- function(input, output, session) {
  output$plotLeft <- renderPlot(plot(cars))
  output$plotTopRight <- renderPlot(plot(pressure))
  output$plotBottomRight <- renderPlot(plot(AirPassengers))
}

shinyApp(ui, server)

}
}
