% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{shinyApp}
\alias{as.shiny.appobj}
\alias{as.shiny.appobj.character}
\alias{as.shiny.appobj.list}
\alias{as.shiny.appobj.shiny.appobj}
\alias{as.tags.shiny.appobj}
\alias{is.shiny.appobj}
\alias{print.shiny.appobj}
\alias{shinyApp}
\alias{shinyAppDir}
\alias{shinyAppFile}
\title{Create a Shiny app object}
\usage{
shinyApp(ui = NULL, server = NULL, onStart = NULL, options = list(),
  uiPattern = "/")

shinyAppDir(appDir, options = list())

shinyAppFile(appFile, options = list())

as.shiny.appobj(x)

\method{as.shiny.appobj}{shiny.appobj}(x)

\method{as.shiny.appobj}{list}(x)

\method{as.shiny.appobj}{character}(x)

is.shiny.appobj(x)

\method{print}{shiny.appobj}(x, ...)

\method{as.tags}{shiny.appobj}(x, ...)
}
\arguments{
\item{ui}{The UI definition of the app (for example, a call to
\code{fluidPage()} with nested controls)}

\item{server}{A server function}

\item{onStart}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}

\item{options}{Named options that should be passed to the `runApp` call. You
can also specify \code{width} and \code{height} parameters which provide a
hint to the embedding environment about the ideal height/width for the app.}

\item{uiPattern}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}

\item{appDir}{Path to directory that contains a Shiny app (i.e. a server.R
file and either ui.R or www/index.html)}

\item{appFile}{Path to a .R file containing a Shiny application}

\item{x}{Object to convert to a Shiny app.}

\item{...}{Additional parameters to be passed to print.}
}
\value{
An object that represents the app. Printing the object or passing it
  to \code{\link{runApp}} will run the app.
}
\description{
These functions create Shiny app objects from either an explicit UI/server
pair (\code{shinyApp}), or by passing the path of a directory that contains a
Shiny app (\code{shinyAppDir}). You generally shouldn't need to use these
functions to create/run applications; they are intended for interoperability
purposes, such as embedding Shiny apps inside a \pkg{knitr} document.
}
\details{
Normally when this function is used at the R console, the Shiny app object is
automatically passed to the \code{print()} function, which runs the app. If
this is called in the middle of a function, the value will not be passed to
\code{print()} and the app will not be run. To make the app run, pass the app
object to \code{print()} or \code{\link{runApp}()}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      numericInput("n", "n", 1),
      plotOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderPlot( plot(head(cars, input$n)) )
    }
  )

  shinyAppDir(system.file("examples/01_hello", package="shiny"))


  # The object can be passed to runApp()
  app <- shinyApp(
    ui = fluidPage(
      numericInput("n", "n", 1),
      plotOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderPlot( plot(head(cars, input$n)) )
    }
  )

  runApp(app)
}

}

