% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/progress.R
\docType{data}
\name{Progress}
\alias{Progress}
\title{Reporting progress (object-oriented API)}
\arguments{
\item{session}{The Shiny session object, as provided by
\code{shinyServer} to the server function.}

\item{min}{The value that represents the starting point of the
progress bar. Must be less tham \code{max}.}

\item{max}{The value that represents the end of the progress bar.
Must be greater than \code{min}.}

\item{message}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message
(if any).}

\item{detail}{A single-element character vector; the detail message
to be displayed to the user, or \code{NULL} to hide the current
detail message (if any). The detail message will be shown with a
de-emphasized appearance relative to \code{message}.}

\item{value}{A numeric value at which to set
the progress bar, relative to \code{min} and \code{max}.
\code{NULL} hides the progress bar, if it is currently visible.}

\item{amount}{Single-element numeric vector; the value at which to set
the progress bar, relative to \code{min} and \code{max}.
\code{NULL} hides the progress bar, if it is currently visible.}

\item{amount}{For the \code{inc()} method, a numeric value to increment the
  progress bar.}
}
\description{
Reports progress to the user during long-running operations.
}
\details{
This package exposes two distinct programming APIs for working with
progress. \code{\link{withProgress}} and \code{\link{setProgress}}
together provide a simple function-based interface, while the
\code{Progress} reference class provides an object-oriented API.

Instantiating a \code{Progress} object causes a progress panel to be
created, and it will be displayed the first time the \code{set}
method is called. Calling \code{close} will cause the progress panel
to be removed.

\strong{Methods}
  \describe{
    \item{\code{initialize(session, min = 0, max = 1)}}{
      Creates a new progress panel (but does not display it).
    }
    \item{\code{set(value = NULL, message = NULL, detail = NULL)}}{
      Updates the progress panel. When called the first time, the
      progress panel is displayed.
    }
    \item{\code{inc(amount = 0.1, message = NULL, detail = NULL)}}{
      Like \code{set}, this updates the progress panel. The difference is
      that \code{inc} increases the progress bar by \code{amount}, instead
      of setting it to a specific value.
    }
    \item{\code{close()}}{
      Removes the progress panel. Future calls to \code{set} and
      \code{close} will be ignored.
    }
  }
}
\examples{
\dontrun{
# server.R
shinyServer(function(input, output, session) {
  output$plot <- renderPlot({
    progress <- shiny::Progress$new(session, min=1, max=15)
    on.exit(progress$close())

    progress$set(message = 'Calculation in progress',
                 detail = 'This may take a while...')

    for (i in 1:15) {
      progress$set(value = i)
      Sys.sleep(0.5)
    }
    plot(cars)
  })
})
}
}
\seealso{
\code{\link{withProgress}}
}
\keyword{datasets}

