% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semanticPage.R
\name{semanticPage}
\alias{semanticPage}
\title{Semantic UI page}
\usage{
semanticPage(
  ...,
  title = "",
  theme = NULL,
  suppress_bootstrap = TRUE,
  margin = "10px"
)
}
\arguments{
\item{...}{Other arguments to be added as attributes of the main div tag
wrapper (e.g. style, class etc.)}

\item{title}{A title to display in the browser's title bar.}

\item{theme}{Theme name or path. Full list of supported themes you will find in
\code{\link[semantic.assets:SUPPORTED_THEMES]{semantic.assets::SUPPORTED_THEMES}}
or at http://semantic-ui-forest.com/themes.}

\item{suppress_bootstrap}{boolean flag that supresses bootstrap when turned on}

\item{margin}{character with body margin size}
}
\description{
This creates a Semantic page for use in a Shiny app.
}
\details{
Inside, it uses two crucial options:

(1) \code{shiny.minified} with a logical value, tells whether it should attach min or full
semnatic css or js (TRUE by default).
(2) \code{shiny.custom.semantic} if this option has not NULL character \code{semanticPage}
takes dependencies from custom css and js files specified in this path
(NULL by default). Depending on \code{shiny.minified} value the folder should contain
either "min" or standard version. The folder should contain: \code{semantic.css} and
\code{semantic.js} files, or \code{semantic.min.css} and \code{semantic.min.js}
in \code{shiny.minified = TRUE} mode.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
library(shiny.semantic)

ui <- semanticPage(
  title = "Hello Shiny Semantic!",
  tags$label("Number of observations:"),
  slider_input("obs", value = 500, min = 0, max = 1000),
  segment(
    plotOutput("dist_plot")
  )
)

server <- function(input, output) {
  output$dist_plot <- renderPlot({
    hist(rnorm(input$obs))
  })
}

shinyApp(ui, server)
}

}
