% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{update_numeric_input}
\alias{update_numeric_input}
\alias{updateNumericInput}
\title{Change numeric input value and settings}
\usage{
update_numeric_input(
  session,
  input_id,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL
)

updateNumericInput(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL
)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{input_id}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{min}{Minimum value.}

\item{max}{Maximum value.}

\item{step}{Step size.}

\item{inputId}{the same as \code{input_id}}
}
\description{
Change numeric input value and settings
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
library(shiny.semantic)

ui <- semanticPage(
  slider_input("slider_in", 5, 0, 10),
  numeric_input("input", "Numeric input:", 0)
)

server <- function(input, output, session) {

  observeEvent(input$slider_in, {
    x <- input$slider_in

    update_numeric_input(session, "input", value = x)
  })
}

shinyApp(ui, server)
}
}
