# Constants

#' Default 404 page
#'
#' This is default 404 page.
#'
#' @export
PAGE_404_ROUTE <- "404"

#' 404 page
#'
#' The page which appear when path is wrong.
#'
#' @param page shiny page style, eg. `div(h1("Not found"))``
#' @param message404 message to display at the 404 website
#'
#' @export
#' @examples
#' page404() # div(h1("Not found"))
#' page404(message404 = "ABC") # div(h1("ABC"))
page404 <- function(page = NULL, message404 = NULL){
  if (is.null(page)) {
    if (is.null(message404)){
      return(shiny::div(shiny::h1("Not found")))
    } else {
      return(shiny::div(shiny::h1(message404)))
    }
  } else {
    return(page)
  }
}
