% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{calculateMutability}
\alias{calculateMutability}
\title{Calculate total mutability}
\usage{
calculateMutability(sequences, model = HH_S5F, progress = FALSE)
}
\arguments{
\item{sequences}{character vector of sequences.}

\item{model}{\link{TargetingModel} object with mutation likelihood information.}

\item{progress}{if \code{TRUE} print a progress bar.}
}
\value{
Numeric vector with a total mutability score for each sequence.
}
\description{
\code{calculateMutability} calculates the total (summed) mutability for a set of sequences 
based on a 5-mer nucleotide mutability model.
}
\examples{
\donttest{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, c_call == "IGHA" & sample_id == "-1h")

# Calculate mutability of germline sequences using \link{HH_S5F} model
mutability <- calculateMutability(sequences=db[["germline_alignment_d_mask"]], model=HH_S5F)
}

}
