% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{minNumSeqMutationsTune}
\alias{minNumSeqMutationsTune}
\title{Parameter tuning for minNumSeqMutations}
\usage{
minNumSeqMutationsTune(mutCount, minNumSeqMutationsRange)
}
\arguments{
\item{mutCount}{a \code{vector} of length 1024 returned by 
\link{createMutabilityMatrix} with \code{numSeqMutationsOnly=TRUE}.}

\item{minNumSeqMutationsRange}{a number or a vector indicating the value or the range of values 
of \code{minNumSeqMutations} to try.}
}
\value{
A 2xn \code{matrix}, where n is the number of trial values of \code{minNumSeqMutations}
             supplied in \code{minNumSeqMutationsRange}. Each column corresponds to a value
             in \code{minNumSeqMutationsRange}. The rows correspond to the number of 5-mers
             for which mutability would be computed directly (\code{"measured"}) and inferred
             (\code{"inferred"}), respectively.
}
\description{
\code{minNumSeqMutationsTune} helps with picking a threshold value for \code{minNumSeqMutations}
in \link{createMutabilityMatrix} by tabulating the number of 5-mers for which 
mutability would be computed directly or inferred at various threshold values.
}
\details{
At a given threshold value of \code{minNumSeqMutations}, for a given 5-mer,
             if the total number of mutations is greater than the threshold, mutability 
             is computed directly. Otherwise, mutability is inferred.
}
\examples{
\donttest{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgA" & SAMPLE == "-1h")

# Create model using only silent mutations
sub <- createSubstitutionMatrix(db, model="S", multipleMutation="independent",
                                returnModel="5mer", numMutationsOnly=FALSE,
                                minNumMutations=20)

# Count the number of mutations in sequences containing each 5-mer
mutCount <- createMutabilityMatrix(db, substitutionModel = sub,
                                   model="S", multipleMutation="independent",
                                   numSeqMutationsOnly=TRUE)

# Tune minNumSeqMutations
minNumSeqMutationsTune(mutCount, seq(from=100, to=300, by=50))
}                                      
}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based 
           on synonymous mutations from high-throughput immunoglobulin sequencing data. 
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
See argument \code{numSeqMutationsOnly} in \link{createMutabilityMatrix} 
             for generating the required input \code{vector} \code{mutCount}. 
             See argument \code{minNumSeqMutations} in \link{createMutabilityMatrix}
             for what it does.
}
