% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{getBaselineStats}
\alias{getBaselineStats}
\title{Gets the summary statistics of a Baseline object}
\usage{
getBaselineStats(baseline)
}
\arguments{
\item{baseline}{\code{Baseline} object that has been run through
either \link{groupBaseline} or \link{summarizeBaseline}.}
}
\value{
A \code{data.frame} with the mean selection strength (mean Sigma), 95\% 
          confidence intervals, and p-values with positive signs for the presence 
          of positive selection and/or p-values with negative signs for the presence 
          of negative selection.
}
\description{
\code{getBaselineStats} is an accessor method that returns the 
summary statistics \code{data.frame} stored in the \code{stats} slot of a 
\link{Baseline} object - provided \link{groupBaseline} has already been run.
}
\examples{
\donttest{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE \%in\% c("IgA", "IgG") & SAMPLE == "+7d")

# Collapse clones
db <- collapseClones(db, sequenceColumn="SEQUENCE_IMGT",
                     germlineColumn="GERMLINE_IMGT_D_MASK",
                     method="thresholdedFreq", minimumFrequency=0.6,
                     includeAmbiguous=FALSE, breakTiesStochastic=FALSE)
                     
# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="SEQUENCE_IMGT",
                         germlineColumn="GERMLINE_IMGT_D_MASK", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc=1)

# Grouping the PDFs by the isotype and sample annotations.
grouped <- groupBaseline(baseline, groupBy=c("SAMPLE", "ISOTYPE"))

# Get a data.frame of the summary statistics
getBaselineStats(grouped)
}
}
\seealso{
For calculating the BASELINe summary statistics see \link{summarizeBaseline}.
}
