% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_predict.R
\name{predict.variable_selection}
\alias{predict.variable_selection}
\title{Predict method for stability selection}
\usage{
\method{predict}{variable_selection}(
  object,
  xdata,
  ydata,
  newdata = NULL,
  method = c("ensemble", "refit"),
  ...
)
}
\arguments{
\item{object}{output of \code{\link{VariableSelection}}.}

\item{xdata}{predictor data (training set).}

\item{ydata}{outcome data (training set).}

\item{newdata}{optional predictor data (test set).}

\item{method}{character string indicating if predictions should be obtained
from an \code{\link{Ensemble}} model (if \code{method="ensemble"}) or a
\code{\link{Refit}}ted model (if \code{method="refit"}).}

\item{...}{additional arguments passed to \code{\link[stats]{predict}}.}
}
\value{
Predicted values.
}
\description{
Computes predicted values from the output of \code{\link{VariableSelection}}.
}
\examples{
\donttest{
## Linear regression

# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 500, pk = 50, family = "gaussian")

# Training/test split
ids <- Split(data = simul$ydata, tau = c(0.8, 0.2))

# Stability selection
stab <- VariableSelection(
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ]
)

# Predictions from post stability selection estimation
yhat <- predict(stab,
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ],
  newdata = simul$xdata[ids[[2]], ],
  method = "refit"
)
cor(simul$ydata[ids[[2]], ], yhat)^2 # Q-squared

# Predictions from ensemble model
yhat <- predict(stab,
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ],
  newdata = simul$xdata[ids[[2]], ],
  method = "ensemble"
)
cor(simul$ydata[ids[[2]], ], yhat)^2 # Q-squared


## Logistic regression

# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 500, pk = 20, family = "binomial", ev_xy = 0.9)

# Training/test split
ids <- Split(data = simul$ydata, family = "binomial", tau = c(0.8, 0.2))

# Stability selection
stab <- VariableSelection(
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ],
  family = "binomial"
)

# Predictions from post stability selection estimation
yhat <- predict(stab,
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ],
  newdata = simul$xdata[ids[[2]], ],
  method = "refit", type = "response"
)
plot(ROC(predicted = yhat, observed = simul$ydata[ids[[2]], ]))

# Predictions from ensemble model
yhat <- predict(stab,
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ],
  newdata = simul$xdata[ids[[2]], ],
  method = "ensemble", type = "response"
)
plot(ROC(predicted = yhat, observed = simul$ydata[ids[[2]], ]),
  add = TRUE,
  col = "blue"
)
}
}
\seealso{
\code{\link{Refit}}, \code{\link{Ensemble}},
  \code{\link{EnsemblePredictions}}
}
