% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_models.R
\name{KMeansClustering}
\alias{KMeansClustering}
\title{K-means clustering}
\usage{
KMeansClustering(xdata, nc = NULL, ...)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{...}{additional parameters passed to \code{\link[stats]{kmeans}}.}
}
\value{
A list with: \item{comembership}{an array of binary and symmetric
  co-membership matrices.} \item{weights}{a matrix of median weights by
  feature.}
}
\description{
Runs k-means clustering using implementation from
\code{\link[stats]{kmeans}}. This function is not using stability.
}
\examples{

# Data simulation
set.seed(1)
simul <- SimulateClustering(n = c(10, 10), pk = 50)

# k-means clustering
mykmeans <- KMeansClustering(xdata = simul$data, nc = 1:20)
}
\seealso{
Other clustering algorithms: 
\code{\link{DBSCANClustering}()},
\code{\link{GMMClustering}()},
\code{\link{HierarchicalClustering}()},
\code{\link{PAMClustering}()}
}
\concept{clustering algorithms}
