% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{plot.roc_band}
\alias{plot.roc_band}
\title{Receiver Operating Characteristic (ROC) band}
\usage{
\method{plot}{roc_band}(
  x,
  col_band = NULL,
  alpha = 0.5,
  quantiles = c(0.05, 0.95),
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{output of \code{\link{ExplanatoryPerformance}}.}

\item{col_band}{colour of the band defined by point-wise \code{quantiles}.}

\item{alpha}{level of opacity for the band.}

\item{quantiles}{point-wise quantiles of the performances defining the band.}

\item{add}{logical indicating if the curve should be added to the current
plot.}

\item{...}{additional plotting arguments (see \code{\link[graphics]{par}}).}
}
\value{
A base plot.
}
\description{
Plots the True Positive Rate (TPR) as a function of the False Positive Rate
(FPR) for different thresholds in predicted probabilities. If the results
from multiple ROC analyses are provided (e.g. output of
\code{\link{ExplanatoryPerformance}} with large \code{K}), the point-wise
median is represented and flanked by a transparent band defined by point-wise
\code{quantiles}.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateRegression(
  n = 1000, pk = 10,
  family = "binomial", ev_xy = 0.7
)

# Balanced split: 50\% variable selection set and 50\% for evaluation of performances
ids_train <- Resample(
  data = simul$ydata,
  tau = 0.5, family = "binomial"
)
xtrain <- simul$xdata[ids_train, ]
ytrain <- simul$ydata[ids_train, ]
xtest <- simul$xdata[-ids_train, ]
ytest <- simul$ydata[-ids_train, ]

# Stability selection
stab <- VariableSelection(xdata = xtrain, ydata = ytrain, family = "binomial")

# Evaluation of the performances on refitted models (K=1)
roc <- ExplanatoryPerformance(
  xdata = xtest, ydata = ytest,
  stability = stab, n_thr = NULL
)
plot(roc)

# Using more refitting/test splits
roc <- ExplanatoryPerformance(
  xdata = xtest, ydata = ytest,
  stability = stab, K = 100
)
boxplot(roc$AUC, ylab = "AUC")
plot(roc)
}
}
\seealso{
\code{\link{ExplanatoryPerformance}}
}
