% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rd_pat.R
\name{print.rd_pat}
\alias{print.rd_pat}
\title{print.rd_pat}
\usage{
\method{print}{rd_pat}(x, calc_energy = TRUE, digits = 4,
  weights = c(0.5, 0.5), ...)
}
\arguments{
\item{x}{Random patterns.}

\item{calc_energy}{If TRUE energy is calculated.}

\item{digits}{Number of decimal places (round).}

\item{weights}{Weights used to calculate energy. The first number refers to Gest(r),
the second number to pcf(r).}

\item{...}{Arguments passed to cat}
}
\description{
Print method for rd_pat object
}
\details{
Printing method for random patterns created with \code{\link{reconstruct_pattern_homo}},
\code{\link{reconstruct_pattern_hetero}}, \code{\link{reconstruct_pattern_cluster}} or
\code{\link{fit_point_process}}.
}
\examples{
pattern_random <- fit_point_process(species_a, n_random = 199)
print(pattern_random)

\dontrun{
pattern_recon <- reconstruct_pattern_hetero(species_b, n_random = 19, max_runs = 1000)
print(pattern_recon)
}

}
\seealso{
\code{\link{reconstruct_pattern_homo}} \cr
\code{\link{reconstruct_pattern_hetero}} \cr
\code{\link{reconstruct_pattern_cluster}} \cr
\code{\link{fit_point_process}}
}
