% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_dependence.R
\name{sv_dependence}
\alias{sv_dependence}
\alias{sv_dependence.default}
\alias{sv_dependence.shapviz}
\title{SHAP Dependence Plot}
\usage{
sv_dependence(object, ...)

\method{sv_dependence}{default}(object, ...)

\method{sv_dependence}{shapviz}(
  object,
  v,
  color_var = NULL,
  color = "#3b528b",
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  interactions = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class "shapviz".}

\item{...}{Arguments passed to \code{geom_jitter()}.}

\item{v}{Column name of feature to be plotted.}

\item{color_var}{Feature name to be used on the color scale to investigate interactions.
The default is \code{NULL} (no color feature). If "auto", the variable with strongest
average absolute SHAP interaction value is picked. If the "shapviz" object does not
contain SHAP interaction values (the usual case), a correlation based heuristic is
used instead.}

\item{color}{Color to be used if \code{color_var = NULL}.}

\item{viridis_args}{List of viridis color scale arguments, see
\code{?ggplot2::scale_color_viridis_c()}. The default points to the global
option \code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}.
These values are passed to \code{ggplot2::scale_color_viridis_*()}.
For example, to switch to a standard viridis scale, you can either change the default
with \code{options(shapviz.viridis_args = NULL)} or set \code{viridis_args = NULL}.
Only relevant if \code{color_var} is not \code{NULL}.}

\item{jitter_width}{The amount of horizontal jitter. The default (\code{NULL}) will
use a value of 0.2 in case \code{v} is discrete, and no jitter otherwise.
(Numeric variables are considered discrete if they have at most 7 unique values.)}

\item{interactions}{Should SHAP interaction values be plotted? Default is \code{FALSE}.
Requires SHAP interaction values. If no \code{color_var} is passed (or it is equal to
\code{v}), the pure main effect of \code{v} is visualized. Otherwise, twice the SHAP
interaction values between \code{v} and the \code{color_var} are plotted.}
}
\value{
An object of class \code{ggplot} representing a dependence plot.
}
\description{
Scatter plot of the SHAP values of a feature against its feature values.
Using a \code{color_var} on the color axis, one can get a sense of possible interaction
effects. Set \code{color_var = "auto"} to automatically select the color feature with
the strongest interaction effects. If SHAP interaction values are available,
this is determined by the average absolute SHAP interaction.
Otherwise, a correlation based heuristic is used instead. If SHAP interaction values are
available, setting \code{interactions = TRUE} allows to focus on pure main effects or
on pure interaction effects (multiplied by two).
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_dependence(default)}: Default method.

\item \code{sv_dependence(shapviz)}: SHAP dependence plot for shp object.

}}
\examples{
dtrain <- xgboost::xgb.DMatrix(data.matrix(iris[, -1]), label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50, nthread = 1)
x <- shapviz(fit, X_pred = dtrain, X = iris)
sv_dependence(x, "Petal.Length")
sv_dependence(x, "Petal.Length", color_var = "Species")
sv_dependence(x, "Species", color_var = "auto")

# SHAP interaction values
x2 <- shapviz(fit, X_pred = dtrain, X = iris, interactions = TRUE)
sv_dependence(x2, "Petal.Length", interactions = TRUE)
sv_dependence(x2, "Petal.Length", color_var = "auto", interactions = TRUE)
}
\seealso{
\code{\link{potential_interactions}}
}
