% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapviz_methods.R
\name{extractors}
\alias{extractors}
\alias{get_shap_values}
\alias{get_shap_values.shapviz}
\alias{get_shap_values.default}
\alias{get_feature_values}
\alias{get_feature_values.shapviz}
\alias{get_feature_values.default}
\alias{get_baseline}
\alias{get_baseline.shapviz}
\alias{get_baseline.default}
\title{Extractor Functions}
\usage{
get_shap_values(object, ...)

\method{get_shap_values}{shapviz}(object, ...)

\method{get_shap_values}{default}(object, ...)

get_feature_values(object, ...)

\method{get_feature_values}{shapviz}(object, ...)

\method{get_feature_values}{default}(object, ...)

get_baseline(object, ...)

\method{get_baseline}{shapviz}(object, ...)

\method{get_baseline}{default}(object, ...)
}
\arguments{
\item{object}{Object to extract something.}

\item{...}{Currently unused.}
}
\value{
\code{get_shap_values()} returns the matrix of SHAP values, \code{get_feature_values()} the \code{data.frame} of feature values, and \code{get_baseline()} the numeric baseline value of the input.
}
\description{
Functions to extract SHAP values, feature values, or the baseline from a "shapviz" object.
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
shp <- shapviz(S, X, baseline = 4)
get_shap_values(shp)
}
