# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computing single H matrix in AICc-function using the Mahalanobis distance
#'
#' @param X matrix.
#' @param mcov matrix
#' The covariance matrix of X.
#' @param S_scale_dist logical.
#' Indicating whether the Mahalanobis distance should be scaled with the number of variables
#' @param h numeric specifying the scaling (sigma)
#'
#' @keywords internal
#'
#' @return Matrix of dimension \code{ncol(X)*ncol(X)}
#' @author Martin Jullum
hat_matrix_cpp <- function(X, mcov, S_scale_dist, h) {
    .Call(`_shapr_hat_matrix_cpp`, X, mcov, S_scale_dist, h)
}

#' Function for computing sigma_hat_sq
#'
#' @param H Matrix.
#' Output from [hat_matrix_cpp()]
#' @param y Vector
#' Representing the (temporary) response variable
#'
#' @keywords internal
#'
#' @return Scalar
#'
#' @author Martin Jullum
rss_cpp <- function(H, y) {
    .Call(`_shapr_rss_cpp`, H, y)
}

#' Correction term with trace_input in AICc formula
#'
#' @param tr_H numeric
#' The trace of H
#' @param n numeric
#' The number of rows in H
#'
#' @keywords internal
#'
#' @return Scalar
#' @author Martin Jullum
correction_matrix_cpp <- function(tr_H, n) {
    .Call(`_shapr_correction_matrix_cpp`, tr_H, n)
}

#'  Temp-function for computing the full AICc with several X's etc
#'
#'
#' @inheritParams hat_matrix_cpp
#' @inheritParams rss_cpp
#'
#' @keywords internal
#'
#' @return Scalar with the numeric value of the AICc formula.
#' @author Martin Jullum
aicc_full_single_cpp <- function(X, mcov, S_scale_dist, h, y) {
    .Call(`_shapr_aicc_full_single_cpp`, X, mcov, S_scale_dist, h, y)
}

#'  AICc formula for several sets, alternative definition
#'
#' @param X_list List.
#' Contains matrices with the appropriate features of the training data
#' @param mcov_list List.
#' Contains the covariance matrices of the matrices in X_list
#' @param S_scale_dist Logical.
#' Indicates whether Mahalanobis distance should be scaled with the number of variables.
#' @param y_list List.
#' Contains the appropriate (temporary) response variables.
#' @param negative Logical.
#' Whether to return the negative of the AICc value.
#'
#' @keywords internal
#'
#' @inheritParams hat_matrix_cpp
#'
#' @return Scalar with the numeric value of the AICc formula
#'
#' @author Martin Jullum
aicc_full_cpp <- function(h, X_list, mcov_list, S_scale_dist, y_list, negative) {
    .Call(`_shapr_aicc_full_cpp`, h, X_list, mcov_list, S_scale_dist, y_list, negative)
}

#' Compute the quantiles using quantile type seven
#'
#' @param x arma::vec.
#' Numeric vector whose sample quantiles are wanted.
#' @param probs arma::vec.
#' Numeric vector of probabilities with values between zero and one.
#'
#' @details Using quantile type number seven from stats::quantile in R.
#'
#' @return A vector of length `length(probs)` with the quantiles is returned.
#'
#' @keywords internal
#' @author Lars Henry Berge Olsen
quantile_type7_cpp <- function(x, probs) {
    .Call(`_shapr_quantile_type7_cpp`, x, probs)
}

#' Transforms new data to a standardized normal distribution
#'
#' @param z arma::mat.
#' The data are the Gaussian Monte Carlos samples to transform.
#' @param x arma::mat.
#' The data with the original transformation. Used to conduct the transformation of `z`.
#'
#' @return arma::mat of the same dimension as `z`
#'
#' @keywords internal
#' @author Lars Henry Berge Olsen
inv_gaussian_transform_cpp <- function(z, x) {
    .Call(`_shapr_inv_gaussian_transform_cpp`, z, x)
}

#' Generate (Gaussian) Copula MC samples
#'
#' @param x_explain_gaussian_mat arma::mat.
#' Matrix of dimension (`n_explain`, `n_features`) containing the observations to explain after being transformed
#' using the Gaussian transform, i.e., the samples have been transformed to a standardized normal distribution.
#' @param x_train_mat arma::mat.
#' Matrix of dimension (`n_train`, `n_features`) containing the training observations.
#' @param mu arma::vec.
#' Vector of length `n_features` containing the mean of each feature after being transformed using the Gaussian
#' transform, i.e., the samples have been transformed to a standardized normal distribution.
#' @param cov_mat arma::mat.
#' Matrix of dimension (`n_features`, `n_features`) containing the pairwise covariance between all pairs of features
#' after being transformed using the Gaussian transform, i.e., the samples have been transformed to a standardized
#' normal distribution.
#'
#' @return An arma::cube/3D array of dimension (`n_MC_samples`, `n_explain` * `n_coalitions`, `n_features`), where
#' the columns (_,j,_) are matrices of dimension (`n_MC_samples`, `n_features`) containing the conditional Gaussian
#' copula MC samples for each explicand and coalition on the original scale.
#'
#' @inheritParams prepare_data_gaussian_cpp
#' @keywords internal
#' @author Lars Henry Berge Olsen
prepare_data_copula_cpp <- function(MC_samples_mat, x_explain_mat, x_explain_gaussian_mat, x_train_mat, S, mu, cov_mat) {
    .Call(`_shapr_prepare_data_copula_cpp`, MC_samples_mat, x_explain_mat, x_explain_gaussian_mat, x_train_mat, S, mu, cov_mat)
}

#' Generate (Gaussian) Copula MC samples for the causal setup with a single MC sample for each explicand
#'
#' @inherit prepare_data_copula_cpp
#'
#' @keywords internal
#' @author Lars Henry Berge Olsen
prepare_data_copula_cpp_caus <- function(MC_samples_mat, x_explain_mat, x_explain_gaussian_mat, x_train_mat, S, mu, cov_mat) {
    .Call(`_shapr_prepare_data_copula_cpp_caus`, MC_samples_mat, x_explain_mat, x_explain_gaussian_mat, x_train_mat, S, mu, cov_mat)
}

#' Generate Gaussian MC samples
#'
#' @param MC_samples_mat arma::mat.
#' Matrix of dimension (`n_MC_samples`, `n_features`) containing samples from the univariate standard normal.
#' @param x_explain_mat arma::mat.
#' Matrix of dimension (`n_explain`, `n_features`) containing the observations to explain.
#' @param S arma::mat.
#' Matrix of dimension (`n_coalitions`, `n_features`) containing binary representations of the used coalitions.
#' S cannot contain the empty or grand coalition, i.e., a row containing only zeros or ones.
#' This is not a problem internally in shapr as the empty and grand coalitions are treated differently.
#' @param mu arma::vec.
#' Vector of length `n_features` containing the mean of each feature.
#' @param cov_mat arma::mat.
#' Matrix of dimension (`n_features`, `n_features`) containing the covariance matrix of the features.
#'
#' @return An arma::cube/3D array of dimension (`n_MC_samples`, `n_explain` * `n_coalitions`, `n_features`), where
#' the columns (_,j,_) are matrices of dimension (`n_MC_samples`, `n_features`) containing the conditional Gaussian
#' MC samples for each explicand and coalition.
#'
#' @keywords internal
#' @author Lars Henry Berge Olsen
prepare_data_gaussian_cpp <- function(MC_samples_mat, x_explain_mat, S, mu, cov_mat) {
    .Call(`_shapr_prepare_data_gaussian_cpp`, MC_samples_mat, x_explain_mat, S, mu, cov_mat)
}

#' Generate Gaussian MC samples for the causal setup with a single MC sample for each explicand
#'
#'
#' @inherit prepare_data_gaussian_cpp
#' @keywords internal
#' @author Lars Henry Berge Olsen
prepare_data_gaussian_cpp_caus <- function(MC_samples_mat, x_explain_mat, S, mu, cov_mat) {
    .Call(`_shapr_prepare_data_gaussian_cpp_caus`, MC_samples_mat, x_explain_mat, S, mu, cov_mat)
}

#' (Generalized) Mahalanobis distance
#'
#' Used to get the Euclidean distance as well by setting \code{mcov} = \code{diag(m)}.
#'
#' @param featureList List.
#' Contains the vectors indicating all factor combinations that should be included in the computations.
#' Assumes that the first one is empty.
#' @param Xtrain_mat Matrix
#' Training data in matrix form
#' @param Xexplain_mat Matrix
#' Explanation data in matrix form.
#'
#' @inheritParams hat_matrix_cpp
#' @keywords internal
#'
#' @return Array of three dimensions. Contains the squared distance for between all training and test observations for all feature combinations passed to the function.
#' @author Martin Jullum
mahalanobis_distance_cpp <- function(featureList, Xtrain_mat, Xexplain_mat, mcov, S_scale_dist) {
    .Call(`_shapr_mahalanobis_distance_cpp`, featureList, Xtrain_mat, Xexplain_mat, mcov, S_scale_dist)
}

#' We here return a vector of strings/characters, i.e., a CharacterVector,
#' where each string is a space-separated list of integers.
#'
#' @param n_coalitions IntegerVector.
#' The number of features to sample for each feature combination.
#' @inheritParams create_coalition_table
#' @keywords internal
sample_coalitions_cpp_str_paired <- function(m, n_coalitions, paired_shap_sampling = TRUE) {
    .Call(`_shapr_sample_coalitions_cpp_str_paired`, m, n_coalitions, paired_shap_sampling)
}

#' Get imputed data
#'
#' @param index_xtrain Positive integer. Represents a sequence of row indices from \code{x_train},
#' i.e. \code{min(index_xtrain) >= 1} and \code{max(index_xtrain) <= nrow(x_train)}.
#'
#' @param index_s Positive integer. Represents a sequence of row indices from \code{S},
#' i.e. \code{min(index_s) >= 1} and \code{max(index_s) <= nrow(S)}.
#'
#' @param x_explain Matrix with 1 row.
#' Contains the features of the observation for a single prediction.
#'
#' @param x_train Matrix.
#' Contains the training data.
#'
#' @details \code{S(i, j) = 1} if and only if feature \code{j} is present in feature
#' combination \code{i}, otherwise \code{S(i, j) = 0}. I.e. if \code{m = 3}, there
#' are \code{2^3 = 8} unique ways to combine the features. In this case \code{dim(S) = c(8, 3)}.
#' Let's call the features \code{x1, x2, x3} and take a closer look at the combination
#' represented by \code{s = c(x1, x2)}. If this combination is represented by the second row,
#' the following is true: \code{S[2, 1:3] = c(1, 1, 0)}.
#'
#' The returned object, \code{X}, is a numeric matrix where
#' \code{dim(X) = c(length(index_xtrain), ncol(x_train))}. If feature \code{j} is present in
#' the k-th observation, that is \code{S[index_[k], j] == 1}, \code{X[k, j] = x_explain[1, j]}.
#' Otherwise \code{X[k, j] = x_train[index_xtrain[k], j]}.
#'
#'
#' @inheritParams prepare_data_gaussian_cpp
#' @keywords internal
#'
#' @return Numeric matrix
#'
#' @author Nikolai Sellereite
observation_impute_cpp <- function(index_xtrain, index_s, x_train, x_explain, S) {
    .Call(`_shapr_observation_impute_cpp`, index_xtrain, index_s, x_train, x_explain, S)
}

#' Calculate weight matrix
#'
#' @param coalitions List.
#' Each of the elements equals an integer vector representing a valid combination of features/feature groups.
#' @param m Integer.
#' Number of features/feature groups.
#' @param n Integer.
#' Number of combinations.
#' @param w Numeric vector
#' Should have length \code{n}. \code{w[i]} equals the Shapley weight of feature/feature group combination \code{i},
#' represented by \code{coalitions[[i]]}.
#'
#' @keywords internal
#'
#' @return Matrix of dimension n x m + 1
#' @author Nikolai Sellereite, Martin Jullum
weight_matrix_cpp <- function(coalitions, m, n, w) {
    .Call(`_shapr_weight_matrix_cpp`, coalitions, m, n, w)
}

#' Get coalition matrix
#'
#' @inheritParams weight_matrix_cpp
#'
#' @export
#' @keywords internal
#'
#'
#' @return Matrix
#' @author Nikolai Sellereite, Martin Jullum
coalition_matrix_cpp <- function(coalitions, m) {
    .Call(`_shapr_coalition_matrix_cpp`, coalitions, m)
}

