% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{categorical_to_one_hot_layer}
\alias{categorical_to_one_hot_layer}
\title{A \code{\link[torch:nn_module]{torch::nn_module()}} Representing a \code{categorical_to_one_hot_layer}}
\usage{
categorical_to_one_hot_layer(
  one_hot_max_sizes,
  add_nans_map_for_columns = NULL
)
}
\arguments{
\item{one_hot_max_sizes}{A torch tensor of dimension \code{n_features} containing the one hot sizes of the \code{n_features}
features. That is, if the \code{i}th feature is a categorical feature with 5 levels, then \code{one_hot_max_sizes[i] = 5}.
While the size for continuous features can either be \code{0} or \code{1}.}

\item{add_nans_map_for_columns}{Optional list which contains indices of columns which is_nan masks are to be appended
to the result tensor. This option is necessary for the full encoder to distinguish whether value is to be
reconstructed or not.}
}
\description{
The \code{categorical_to_one_hot_layer} module/layer expands categorical features into one-hot vectors,
because multi-layer perceptrons are known to work better with this data representation.
It also replaces NaNs with zeros in order so that further layers may work correctly.
}
\details{
Note that the module works with mixed data represented as 2-dimensional inputs and it
works correctly with missing values in \code{groundtruth} as long as they are represented by NaNs.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
