% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solarpos2.R
\name{solarpos2}
\alias{solarpos2}
\title{Calculate solar position(s) for location and time}
\usage{
solarpos2(location, time)
}
\arguments{
\item{location}{A \code{Spatial*} or a \code{Raster} object}

\item{time}{A \code{SpatialLines*} or a \code{SpatialPolygons*} object}
}
\value{
A \code{matrix} with two columns representing sun position(s); first column is the solar azimuth (in decimal degrees from North), second column is sun elevation (in decimal degrees); rows represent different times corresponding to \code{time}
}
\description{
This is a wrapper function around \code{maptools::solarpos}, adapted for accepting location as a \code{Spatial*} layer or a \code{Raster}. The function calculates layer centroid, transforms it to lon-lat, then calls \code{maptools::solarpos} to calculate solar position(s) for that point at the given time(s)
}
\examples{
time = as.POSIXct("2004-12-24 13:30:00", tz = "Asia/Jerusalem")
solarpos2(build, time)

}
