% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtures.R
\name{addmix}
\alias{addmix}
\alias{submix}
\alias{\%.)\%}
\alias{\%_/\%}
\title{Colour mixtures}
\usage{
addmix(base, mixer, amount = 1, space = NULL)

submix(base, mixer, amount = 1, space = NULL)

X \%.)\% Y

X \%_/\% Y
}
\arguments{
\item{base, X}{A vector of base colours.}

\item{mixer, Y}{A vector of colours to mix in.}

\item{amount}{The amount of each colour to mix in, relative to the amount
of the base. This will be recycled to the length of \code{mixer}.}

\item{space}{A string giving the space in which to perform the mixing, or
\code{NULL}. In the latter case, the space of \code{base} will be used.}
}
\description{
These functions allow colours to be mixed in any colour space, either
additively (like light) or subtractively (like paint). The infix form
\code{\%.)\%} is an alternative for \code{addmix}, and \code{\%_/\%} for
\code{submix}, with the mixing amount being fixed to 1 in these cases.
}
\examples{
addmix(c("red","green","blue"), "red")
submix(c("cyan","magenta","yellow"), "cyan")
}
\author{
Jon Clayden <code@clayden.org>
}
