% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance.R
\name{calculate_distance}
\alias{calculate_distance}
\title{Distance to access layer}
\usage{
calculate_distance(
  raster,
  access,
  plot = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{raster}{spatRaster. Raster to be used to calculate pixel level distance to access layer.}

\item{access}{sf 'LINESTRING' or 'MULTILINESTRING'. Access network.}

\item{plot}{Logical. Plots output strata raster with samples.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}
}
\value{
Input raster with \code{dist2access} layer appended.
}
\description{
Per pixel distance to nearest access vector. Intended to be used as a `cost` constraint
within the \code{\link{sample_clhs}} function
}
\examples{
\dontrun{
#--- Load raster and access files ---#
r <- system.file("extdata", "mraster_small.tif", package = "sgsR")
mr <- terra::rast(r)

a <- system.file("extdata", "access.shp", package = "sgsR")
ac <- sf::st_read(a)

calculate_distance(
  raster = mr,
  access = ac,
)
}

}
\seealso{
Other calculate functions: 
\code{\link{calculate_allocation}()},
\code{\link{calculate_coobs}()},
\code{\link{calculate_pcomp}()},
\code{\link{calculate_pop}()},
\code{\link{calculate_representation}()},
\code{\link{calculate_sampsize}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{calculate functions}
