% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.sgs}
\alias{predict.sgs}
\title{predict using a \code{"sgs"} object}
\usage{
\method{predict}{sgs}(object, x, ...)
}
\arguments{
\item{object}{an object of class \code{"sgs"} from a call to \code{\link[=fit_sgs]{fit_sgs()}}.}

\item{x}{Input data to use for prediction.}

\item{...}{further arguments passed to stats function.}
}
\value{
A list containing:
item{response}{The predicted response. In the logistic case, this represents the predicted class probabilities.}
item{class}{The predicted class assignments. Only returned if type = "logistic" in the \code{"sgs"} object.}
}
\description{
Performs prediction from an \code{\link[=fit_sgs]{fit_sgs()}} model fit.
}
\examples{
# specify a grouping structure
groups = c(1,1,1,2,2,3,3,3,4,4)
# generate data
data = generate_toy_data(p=10, n=5, groups = groups, seed_id=3,group_sparsity=1)
# run SGS 
model = fit_sgs(X = data$X, y = data$y, groups = groups, type="linear", lambda = 1, alpha=0.95, 
vFDR=0.1, gFDR=0.1, standardise = "l2", intercept = TRUE, verbose=FALSE)
# use predict function
model_predictions = predict(model, x = data$X)
}
\seealso{
\code{\link[=fit_sgs]{fit_sgs()}}

Other SGS-methods: 
\code{\link{plot.sgs_cv}()},
\code{\link{print.sgs}()}
}
\concept{SGS-methods}
