\name{pair}
\title{Pair Object}
\usage{pair(point.obj,num.lags=10,type='isotropic', theta=0, dtheta=5, maxdist) }
\alias{pair}
\arguments{
\item{point.obj}{a point object generated by \code{point()}} 
\item{num.lags}{the number of lags into which to divide the pairs of points in the pair object. The lags are all of equal size.} 
\item{type}{either \code{
'isotropic'} or \code{'anisotropic'}. If \code{'isotropic'} then all \eqn{n \choose 2} possible pairs of points are represented in the pair
object. If \code{'anisotropic'}, then the arguments \code{theta} and \code{dtheta} are used to determine which pairs of points to include.}
\item{theta}{an angle, measured in degrees from the horizontal x axis, that determines pairs of points to be included in the \code{pair}
object (see Notes below).}
\item{dtheta}{a tolerance angle, around \code{theta}, measured in degrees that determines pairs of points to be included in the \code{pair}
object (see Notes below).}
\item{maxdist}{the distance beyond which not to consider pairs of points. A large number of spatial locations can cause the
\code{pair} function to consume a considerable amount of computation time. In most cases, spatial dependence can be
adaquately characterized without examining the entire spaital extent of the data set.}
}
\value{A \code{pair} object:
\item{from}{vector of indices into the point object for "from" point}
\item{to}{vector of indices into the point object for "to" point}
\item{lags}{vector of spatial lags of each pair}
\item{dist}{vector of distances between each pair}
\item{bins}{vector of spatial midpoints of each lag (used for plotting)}
 }
\description{Create a pair object from a point object.



A pair object contains information defining pairs of points contained in a point object. A pair object is a list containing five
vectors: \code{from}, \code{to}, \code{lags}, \code{dist}, and \code{bins}. The length of each of these vectors (except \code{bins}) is equal to the number of pairs of
points being represented, say k. The vectors \code{from} and \code{to} contain pointers into the vectors of a point object, pointing to each
member of the pair of points (e.g., from[k] points to si and to[k] points to sj). The vector \code{dist} contains the distance between the
pairs of points. The vector \code{lags} contains the lag number to which each pair of points has been assigned. The vector \code{bins} contains
the spatial midpoint between each lag and is used for plotting.  }
\note{When creating an anisotropic pair object, the assumption is that the direction, as well as the distance, between pairs of
points is important in describing the variation. Using the theta and dtheta arguments, pairs of points that meet direction
requirements can be selected. A pair of points will be included when the angle between the positive x axis and the vector
formed by the pair of points falls within the tolerance angle given by
\emph{(theta-dtheta,theta+dtheta)}}
\section{NOTE}{Name of this function changed from \code{pairs} to \code{pair} to avoid conflicts with R's \code{\link{pairs}} function!!}
\seealso{\code{\link{point}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.point"))==0){example(point)}
}
maas.pair   <- pair(maas.point,num.lags=10,maxdist=2000)
maas.pair25 <- pair(maas.point,num.lags=10,type='anisotropic',
                      theta=25,maxdist=500)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{sgeostat}
