% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp.airwls.update}
\alias{cpp.airwls.update}
\title{AIRWLS update for GMF models}
\usage{
cpp.airwls.update(
  beta,
  Y,
  X,
  familyname,
  linkname,
  varfname,
  idx,
  offset,
  weights,
  penalty,
  transp = FALSE,
  nsteps = 100L,
  stepsize = 0.1,
  print = FALSE,
  parallel = FALSE,
  nthreads = 1L
)
}
\arguments{
\item{beta}{initial value of the regression coefficients to be estimated}

\item{Y}{response vector}

\item{X}{design matrix}

\item{familyname}{model family name}

\item{linkname}{link function name}

\item{varfname}{variance function name}

\item{idx}{index identifying the parameters to be updated in \code{beta}}

\item{offset}{vector of constants to be added to the linear predictor}

\item{weights}{vector of constants non-negative weights}

\item{penalty}{penalty parameter of a ridge-type penalty}

\item{transp}{if \code{TRUE}, transpose the data}

\item{nsteps}{number of iterations}

\item{stepsize}{stepsize parameter of the Fisher scoring algorithm}

\item{print}{if \code{TRUE}, print the algorithm history}

\item{parallel}{if \code{TRUE}, run the updates in parallel using \code{openMP}}

\item{nthreads}{number of threads to be run in parallel (only if \code{parallel=TRUE})}
}
\description{
Internal function implementing one step of AIRWLS for the
estimation of GMF models.
}
\keyword{internal}
