% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burst_tj.R
\name{active_group}
\alias{active_group}
\title{Access the active_group value}
\usage{
active_group(x)
}
\arguments{
\item{x}{a c_grouping}
}
\description{
The active group is the combination of group names to group the data sets.
The active_group acts essentially like a paste(names_of_groups, sep = '_') grouping variable.
}
\examples{
#'
data("raccoon")
raccoon$timestamp <- as.POSIXct(raccoon$timestamp, "EST")
burstz <- list(id = raccoon$animal_id, month = as.POSIXlt(raccoon$timestamp)$mon)
mb1 <- make_c_grouping(x = burstz, active_group = c("id", "month"))

# see the current active burst
active_group(mb1)

# change the active burst
active_group(mb1) <- "id"

# Using a full data set
my_track <- as_sftrack(raccoon,
  time = "timestamp",
  error = NA, coords = c("longitude", "latitude"),
  group = burstz
)

summary(my_track)

# change active group
active_group(my_track$sft_group) <- "id"

summary(my_track)
}
