% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_coordinates}
\alias{node_coordinates}
\alias{node_X}
\alias{node_Y}
\alias{node_Z}
\alias{node_M}
\title{Query node coordinates}
\usage{
node_X()

node_Y()

node_Z()

node_M()
}
\value{
A numeric vector of the same length as the number of nodes in the
network.
}
\description{
These functions allow to query specific coordinate values from the
geometries of the nodes.
}
\details{
Just as with all query functions in tidygraph, these functions
are meant to be called inside tidygraph verbs such as
\code{\link[tidygraph]{mutate}} or \code{\link[tidygraph]{filter}}, where
the network that is currently being worked on is known and thus not needed
as an argument to the function. If you want to use an algorithm outside of
the tidygraph framework you can use \code{\link[tidygraph]{with_graph}} to
set the context temporarily while the algorithm is being evaluated.
}
\note{
If a requested coordinate value is not available for a node, \code{NA}
will be returned.
}
\examples{
library(sf, quietly = TRUE)
library(tidygraph, quietly = TRUE)

# Create a network.
net = as_sfnetwork(roxel)

# Use query function in a filter call.
filtered = net \%>\%
  activate("nodes") \%>\%
  filter(node_X() > 7.54)

oldpar = par(no.readonly = TRUE)
par(mar = c(1,1,1,1))
plot(net, col = "grey")
plot(filtered, col = "red", add = TRUE)
par(oldpar)

# Use query function in a mutate call.
net \%>\%
  activate("nodes") \%>\%
  mutate(X = node_X(), Y = node_Y())

}
